const menus = [
  {
    name: 'dashboard',
    route: 'dashboard',
    icon: 'home',
    hidden: false,
    heading: 'Main',
    sub_menu: false,
    permissions: ['all'],
    lang: { helper: null, main: 'Dashboard' },
  },
  {
    name: 'sales',
    route: null,
    icon: 'cart',
    hidden: false,
    heading: null,
    children: ['sales'],
    lang: { helper: null, main: 'Sales' },
    permissions: ['read-sales', 'create-sales', 'update-sales'],
    sub_menu: [
      {
        name: 'sales.list',
        route: 'sales',
        icon: 'cart',
        hidden: false,
        sub_menu: false,
        target: 'sales',
        permissions: ['read-sales'],
        lang: { helper: 'list_x', main: 'Sales' },
      },
      {
        name: 'sales.create',
        route: 'sales.create',
        icon: 'plus',
        hidden: false,
        sub_menu: false,
        target: 'sales',
        permissions: ['create-sales'],
        lang: { helper: 'create_x', main: 'Sale' },
      },
    ],
  },
  {
    name: 'customers',
    route: null,
    icon: 'group',
    hidden: false,
    heading: null,
    children: ['customers'],
    lang: { helper: null, main: 'Customers' },
    permissions: ['read-customers', 'create-customers', 'update-customers'],
    sub_menu: [
      {
        name: 'customers.list',
        route: 'customers',
        icon: 'group',
        hidden: false,
        sub_menu: false,
        target: 'customers',
        permissions: ['read-customers'],
        lang: { helper: 'list_x', main: 'Customers' },
      },
      {
        name: 'customers.create',
        route: 'customers.create',
        icon: 'plus',
        hidden: false,
        sub_menu: false,
        target: 'customers',
        permissions: ['create-customers'],
        lang: { helper: 'create_x', main: 'Customer' },
      },
    ],
  },
  //   {
  //     route: null,
  //     icon: 'rate',
  //     hidden: false,
  //     heading: null,
  //     name: 'tax_rates',
  //     children: ['tax_rates'],
  //     lang: { helper: null, main: 'Tax Rates' },
  //     permissions: ['read-tax-rates', 'create-tax-rates', 'update-tax-rates'],
  //     sub_menu: [
  //       {
  //         name: 'tax_rates.list',
  //         route: 'tax_rates',
  //         icon: null,
  //         hidden: false,
  //         sub_menu: false,
  //         target: 'tax_rates',
  //         permissions: ['read-tax-rates'],
  //         lang: { helper: 'list_x', main: 'Tax Rates' },
  //       },
  //       {
  //         name: 'tax_rates.create',
  //         route: 'tax_rates.create',
  //         icon: null,
  //         hidden: false,
  //         sub_menu: false,
  //         target: 'tax_rates',
  //         permissions: ['create-tax-rates'],
  //         lang: { helper: 'create_x', main: 'Tax Rate' },
  //       },
  //     ],
  //   },
  {
    name: 'users',
    route: null,
    icon: 'users',
    hidden: false,
    heading: null,
    children: ['users', 'roles'],
    lang: { helper: null, main: 'Users' },
    permissions: ['read-users', 'create-users', 'update-users', 'read-roles', 'create-roles', 'update-roles'],
    sub_menu: [
      {
        name: 'users.list',
        route: 'users',
        icon: 'users',
        hidden: false,
        sub_menu: false,
        permissions: ['read-users'],
        lang: { helper: 'list_x', main: 'Users' },
      },
      {
        name: 'users.create',
        route: 'users.create',
        icon: 'add-user',
        hidden: false,
        sub_menu: false,
        permissions: ['create-users'],
        lang: { helper: 'create_x', main: 'User' },
      },
      {
        name: 'roles.list',
        route: 'roles',
        icon: 'adj',
        hidden: false,
        sub_menu: false,
        permissions: ['read-roles'],
        lang: { helper: 'list_x', main: 'Roles' },
      },
      {
        name: 'roles.create',
        route: 'roles.create',
        icon: 'plus',
        hidden: false,
        sub_menu: false,
        permissions: ['create-roles'],
        lang: { helper: 'create_x', main: 'Role' },
      },
    ],
  },
  {
    name: 'activity',
    route: 'activity',
    icon: 'doc-text',
    hidden: false,
    access: 'super',
    heading: 'Misc',
    sub_menu: false,
    permissions: ['read-activity'],
    lang: { helper: null, main: 'Activity' },
  },
  {
    name: 'report',
    route: 'report',
    icon: 'chart-pie',
    hidden: false,
    access: 'super',
    heading: 'Report',
    sub_menu: false,
    permissions: ['read-report'],
    lang: { helper: null, main: 'Report' },
  },
];
export default menus;
